/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.image;

import com.andavin.images.MapHelper;
import com.andavin.images.image.CustomImageSection;
import com.andavin.util.LocationUtil;
import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class CustomImage
implements Serializable {
    private static final long serialVersionUID = 152608317193555652L;
    public static final UUID UNKNOWN_CREATOR = new UUID(-7650016060676093479L, -6847602434101430799L);
    private static final int PIXELS_PER_FRAME = 128;
    private transient int id = -1;
    private transient Location location;
    private final UUID creator;
    private final String imageName;
    private final BlockFace direction;
    private final Map<Integer, CustomImageSection> sections = new HashMap<Integer, CustomImageSection>();

    public CustomImage(String imageName, Location location, BlockFace direction, BufferedImage image) {
        this(UNKNOWN_CREATOR, imageName, location, direction, image);
    }

    public CustomImage(UUID creator, String imageName, Location location, BlockFace direction, BufferedImage image) {
        this.imageName = imageName;
        this.direction = direction;
        this.location = location;
        this.creator = creator;
        this.update(image);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public String getImageName() {
        return this.imageName;
    }

    public BlockFace getDirection() {
        return this.direction;
    }

    public CustomImageSection getSection(int frameId) {
        return this.sections.get(frameId);
    }

    public CustomImageSection getSectionByMap(int mapId) {
        for (CustomImageSection section : this.sections.values()) {
            if (section.getMapId() != mapId) continue;
            return section;
        }
        return null;
    }

    public void refresh(Player player, Location location) {
        for (CustomImageSection section : this.sections.values()) {
            boolean sameWorld;
            boolean bl = sameWorld = location != null && section.getLocation().getWorld().equals(location.getWorld());
            if (sameWorld) {
                double distance = section.getLocation().distanceSquared(location);
                if (distance <= 4096.0) {
                    section.show(player);
                    continue;
                }
                if (!(distance > 16384.0)) continue;
                section.hide(player);
                continue;
            }
            section.hide(player);
        }
    }

    public void remove(Player player, boolean online) {
        for (CustomImageSection section : this.sections.values()) {
            if (online) {
                section.hide(player);
                continue;
            }
            section.shown.remove(player.getUniqueId());
        }
    }

    public Set<Player> destroy() {
        int sections = this.sections.size();
        if (sections != 0) {
            int index = 0;
            int[] ids = new int[sections];
            HashSet<Player> players = new HashSet<Player>(sections);
            for (CustomImageSection section : this.sections.values()) {
                ids[index++] = section.getFrameId();
                section.shown.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(players::add);
            }
            for (Player player : players) {
                MapHelper.destroyMaps(player, ids);
            }
            this.sections.clear();
            return players;
        }
        return Collections.emptySet();
    }

    private void update(BufferedImage image) {
        int rotation;
        BlockFace face;
        Set<Player> players = this.destroy();
        switch (this.direction) {
            case UP: {
                face = LocationUtil.getCardinalDirection(this.location).getOppositeFace();
                rotation = (int)(LocationUtil.getDifference(BlockFace.SOUTH, face) / 90.0f);
                break;
            }
            case DOWN: {
                face = LocationUtil.getCardinalDirection(this.location).getOppositeFace();
                rotation = (int)(LocationUtil.getDifference(face, BlockFace.SOUTH) / 90.0f);
                break;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                face = BlockFace.SELF;
                rotation = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid direction " + this.direction);
            }
        }
        int xSections = Math.max(image.getWidth() / 128, 1);
        int ySections = Math.max(image.getHeight() / 128, 1);
        image = CustomImage.resize(image, xSections, ySections);
        for (int x = 0; x < xSections; ++x) {
            for (int y = 0; y < ySections; ++y) {
                Location loc = this.location.clone();
                switch (this.direction) {
                    case UP: {
                        switch (face) {
                            case NORTH: {
                                loc.add((double)(-x), 0.0, (double)(-y));
                                break;
                            }
                            case SOUTH: {
                                loc.add((double)x, 0.0, (double)y);
                                break;
                            }
                            case EAST: {
                                loc.add((double)y, 0.0, (double)(-x));
                                break;
                            }
                            case WEST: {
                                loc.add((double)(-y), 0.0, (double)x);
                            }
                        }
                        break;
                    }
                    case DOWN: {
                        switch (face) {
                            case NORTH: {
                                loc.add((double)(-x), 0.0, (double)y);
                                break;
                            }
                            case SOUTH: {
                                loc.add((double)x, 0.0, (double)(-y));
                                break;
                            }
                            case EAST: {
                                loc.add((double)(-y), 0.0, (double)(-x));
                                break;
                            }
                            case WEST: {
                                loc.add((double)y, 0.0, (double)x);
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        loc.add((double)(-x), (double)(-y), 0.0);
                        break;
                    }
                    case SOUTH: {
                        loc.add((double)x, (double)(-y), 0.0);
                        break;
                    }
                    case EAST: {
                        loc.add(0.0, (double)(-y), (double)(-x));
                        break;
                    }
                    case WEST: {
                        loc.add(0.0, (double)(-y), (double)x);
                    }
                }
                CustomImageSection section = new CustomImageSection(loc, this.direction, rotation, image.getSubimage(x * 128, y * 128, 128, 128));
                this.sections.put(section.getFrameId(), section);
            }
        }
        for (Player player : players) {
            this.refresh(player, player.getLocation());
        }
    }

    public boolean isInRange(Location location, int range) {
        if (!this.location.getWorld().equals(location.getWorld())) {
            return false;
        }
        int rangeSqrd = range * range;
        if (this.location.distanceSquared(location) <= (double)rangeSqrd) {
            return true;
        }
        for (CustomImageSection section : this.sections.values()) {
            if (!(section.getLocation().distanceSquared(location) <= (double)rangeSqrd)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomImage)) {
            return false;
        }
        CustomImage image = (CustomImage)obj;
        return this.direction == image.direction && this.imageName.equals(image.imageName) && this.creator.equals(image.creator) && this.location.equals((Object)image.location);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CustomImage.writeLocation(out, this.location);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.location = CustomImage.readLocation(in);
        CustomImageSection[] sections = this.sections.values().toArray(new CustomImageSection[0]);
        this.sections.clear();
        for (CustomImageSection section : sections) {
            this.sections.put(section.getFrameId(), section);
        }
    }

    static void writeLocation(ObjectOutputStream out, Location location) throws IOException {
        out.writeObject(location.getWorld().getName());
        out.writeInt(location.getBlockX());
        out.writeInt(location.getBlockY());
        out.writeInt(location.getBlockZ());
        out.writeFloat(location.getYaw());
        out.writeFloat(location.getPitch());
    }

    static Location readLocation(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String name = (String)in.readObject();
        World world = Bukkit.getWorld((String)name);
        Preconditions.checkState((world != null ? 1 : 0) != 0, (String)"unknown world with ID %s", (Object[])new Object[]{name});
        return new Location(world, (double)in.readInt(), (double)in.readInt(), (double)in.readInt(), in.readFloat(), in.readFloat());
    }

    private static BufferedImage resize(BufferedImage image, int xSections, int ySections) {
        if (image.getWidth() % 128 == 0 && image.getHeight() % 128 == 0) {
            return image;
        }
        Image img = image.getScaledInstance(xSections * 128, ySections * 128, 1);
        image = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2D = image.createGraphics();
        g2D.drawImage(img, 0, 0, null);
        g2D.dispose();
        return image;
    }
}

